#ifndef _SQLIMPORT_CPP
#define _SQLIMPORT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/CGetPKs/CGetPKs.H"
#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "Console.H"
#include "SQLImport.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeSingleRowDataColumns(struct _SQLImportMembers *SIM, int iColumnCount)
{
    Assert(SIM == NULL, "Proc: FreeSingleRowDataColumns");
	
	int iColumnPos = 0;
    while(iColumnPos < iColumnCount)
    {
		free(SIM->SingleRowData[iColumnPos]);
        SIM->SingleRowData[iColumnPos] = NULL;
        iColumnPos++;
    }

	SIM->iOutDataType[iColumnPos] = 0;
	SIM->iOutColumnSize[iColumnPos] = 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeColumnNames(struct _SQLImportMembers *SIM, int iColumnCount)
{
	Assert(SIM == NULL, "Proc: FreeColumnNames");

	int iColumnPos = 0;
    while(iColumnPos < iColumnCount)
    {
        free(SIM->ColumnNames[iColumnPos]);
        SIM->ColumnNames[iColumnPos] = NULL;
        iColumnPos++;
    }

	free(SIM->iOutDataType);
	free(SIM->iOutColumnSize);
	
	free(SIM->ColumnNames);
    SIM->ColumnNames = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeSingleRowData(struct _SQLImportMembers *SIM)
{
    Assert(SIM == NULL, "Proc: FreeSingleRowData");

	free(SIM->SingleRowData);
    SIM->SingleRowData = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ImportSQLResults(CSockSrvr *pSockSrvr, int iClient, bool bCheckExistance, char *InFileName)
{
    Assert(pSockSrvr == NULL, "Proc: ImportSQLResults");

	char sImportTable[255]; //The name of the table that were gogin to be importing into.
    char sStatusText[MAX_STATUS_TEXT]; //Just some RAM for status text and error messages.
    char sAltTemp[MAX_STATUS_TEXT];    //Just some RAM for status text and error messages.

	//char **sUniuqeKeyNames = NULL;        // Contains the names of the uniuqe Columns.
    int *iUniuqeKeyCols = NULL;           // Contains the Column position of the uniuqe Columns.
    int iUniuqeKeysNeeded = 0;            // The ammount of uniuqe keys we have to find.
    int iUniuqeKeysFound = 0;             // The ammount of uniuqe keys we have found.
    int iTotalLengthOfAllColumnNames = 0; // For better memory management.
    int iTotalLengthOfAllRowData = 0;     // For better memory management.
    int iImportTableNameLen = 0;
    int iColumnCount = 0;
    int iRowCount = 0;
    int iColNameLen = 0;
    int iColumnPos = 0;
	bool bIsDelete = false; //Is the data we received a list of rows to delete?

	CGetPKs cMyPKs;

    FILE *hSource = NULL;

    _SQLImportMembers SIM;

    CRecordSet rsTemp;

    if((hSource = fopen(InFileName, "rb")) == NULL)
    {
		sprintf(sStatusText, "Error in ImportSQLResultsFailed:: TargetFile open error. Name: \"%s\"\n", InFileName);
		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

        return false;
    }

    fread(&iImportTableNameLen, sizeof(iImportTableNameLen), 1, hSource); // Read import table name len.
    fread(sImportTable, sizeof(char), iImportTableNameLen, hSource); // Read import table name.
    fread(&iColumnCount, sizeof(iColumnCount), 1, hSource); // Read number of Columns.
    fread(&iRowCount, sizeof(iRowCount), 1, hSource);       // Read number of rows.
    sImportTable[iImportTableNameLen] = '\0';

	sprintf(sStatusText, "Processing transaction data. [%s - %d Rows, %d Columns]", sImportTable, iRowCount, iColumnCount);
	WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

	char sRight[100];
	Right(sImportTable, sRight, iImportTableNameLen, 15);

	if( strcmp(sRight, "_SQLExch_Delete") == 0)
	{
		bIsDelete = true;
		
		//Turncate the import tale. Trimming off the "_SQLExch_Delete"
		sImportTable[iImportTableNameLen - 15] = '\0';
	}

	//Get a list of primary keys for the import table.
	//sUniuqeKeyNames = GetPrimaryKeysEx(&CCI[iClient].cCustSQL, sImportTable, &iUniuqeKeysNeeded, NULL);
	cMyPKs.Get(&CCI[iClient].cCustSQL, CCI[iClient].sCompanyDatabase, "DBO", sImportTable);

	iUniuqeKeysNeeded = cMyPKs.iPKs;

	if(iUniuqeKeysNeeded > 0)
	{
		iUniuqeKeyCols = (int *) calloc(sizeof(int), iUniuqeKeysNeeded);
	}
	else{
		//No primary keys, cannot import this data.
		WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: Could not obtain a list of primary keys.");

        cMyPKs.Free();
		fclose(hSource);
        return false;
	}

	//Allocate RAM for the list of column names.
	SIM.ColumnNames = (char **) calloc(sizeof(char *), iColumnCount + 1);
	SIM.iOutDataType = (int *) calloc(sizeof(int), iColumnCount + 1);
	SIM.iOutColumnSize = (int *) calloc(sizeof(int), iColumnCount + 1);
    
	//Loop through, reading all of the column names from the file.
	while(iColumnPos < iColumnCount)
    {
        fread(&SIM.iOutDataType[iColumnPos], sizeof(int), 1, hSource);
        fread(&SIM.iOutColumnSize[iColumnPos], sizeof(int), 1, hSource);

		fread(&iColNameLen, sizeof(iColNameLen), 1, hSource);
        SIM.ColumnNames[iColumnPos] = (char *) calloc(sizeof(char), iColNameLen + 1);
        fread(SIM.ColumnNames[iColumnPos], sizeof(char), iColNameLen, hSource);
        SIM.ColumnNames[iColumnPos][iColNameLen] = '\0';
        iTotalLengthOfAllColumnNames = (iTotalLengthOfAllColumnNames + iColNameLen);

        //If this column name matches one of our Primary Keys then record its position
		//	in iUniuqeKeyCols[]
        if(iUniuqeKeysFound < iUniuqeKeysNeeded)
        {
            int UniuqeKeyCount = 0;
            while(UniuqeKeyCount < iUniuqeKeysNeeded)
            {
                //if(strcmpi(sUniuqeKeyNames[UniuqeKeyCount], SIM.ColumnNames[iColumnPos]) == 0)
				if(strcmpi(cMyPKs.sPKs[UniuqeKeyCount], SIM.ColumnNames[iColumnPos]) == 0)
                {
                    iUniuqeKeyCols[UniuqeKeyCount] = iColumnPos;
                    iUniuqeKeysFound++;
                }
                UniuqeKeyCount++;
            }
        }

        iColumnPos++;
    }

	int UniuqeKeyCount = 0;
    while(iUniuqeKeysNeeded < iUniuqeKeysFound)
    {
        sprintf(sStatusText, "Error in ImportSQLResultsFailed:: Required uniuqe keys were not found for: '%s'.", sImportTable);
		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

        FreeColumnNames(&SIM, iColumnCount);

        cMyPKs.Free();
        fclose(hSource);
        return false;
    }

    if( pSockSrvr->bcConnected[iClient] == false )
    {
		if(bIsDelete)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Disconnected before data import.");
		}
		else{
			WriteLog(pSockSrvr->icClientID[iClient], "Disconnected before data deletion.");
		}

        cMyPKs.Free();
        fclose(hSource);
        return false;
    }

    //Allocate an Array large enough to hold all of the row data.
	SIM.SingleRowData = (char **) calloc(sizeof(char *), iColumnCount + 1);

	int RowDataLen = 0;

    int RowPos = 0;
    while(RowPos < iRowCount)
    {
        int BaseMemoryRequirement = 0;
        iTotalLengthOfAllRowData = 0;

        // Get row data.
        iColumnPos = 0;
        while(iColumnPos < iColumnCount)
        {
            fread(&RowDataLen, sizeof(RowDataLen), 1, hSource);
            if((SIM.SingleRowData[iColumnPos] = (char *) calloc(sizeof(char), RowDataLen + 1)) == NULL)
			{
				WriteLog(pSockSrvr->icClientID[iClient], "Failed to allocate memory for SingleRowData[].");
				giErrorCount++;

		        cMyPKs.Free();
		        fclose(hSource);
				return false;
			}
			fread(SIM.SingleRowData[iColumnPos], sizeof(char), RowDataLen, hSource);
			
            SIM.SingleRowData[iColumnPos][RowDataLen] = '\0';
            iTotalLengthOfAllRowData = (iTotalLengthOfAllRowData + RowDataLen);
            iColumnPos++;
        }

        BaseMemoryRequirement = ((iTotalLengthOfAllColumnNames + iTotalLengthOfAllRowData) + (iColumnCount * 5)) + 1024;

        char WhereStatement[1024];
        char CheckExistanceStatement[1024];
        int iCountOfRowsThatAlreadyExist = 0;

        // Assemble the where statement from the row data, the uniuqe key names and positions.
        if(iUniuqeKeysFound > 0)
        {
            // Assemble the where statement
            sprintf(WhereStatement, "WHERE %s = %s", cMyPKs.sPKs[0], SIM.SingleRowData[iUniuqeKeyCols[0]]);
        	int UniuqeKeyCount = 1;
            while(UniuqeKeyCount < iUniuqeKeysFound)
            {
                strcat(WhereStatement, " AND [");
                strcat(WhereStatement, cMyPKs.sPKs[UniuqeKeyCount]);
                strcat(WhereStatement, "] = ");
                strcat(WhereStatement, SIM.SingleRowData[iUniuqeKeyCols[UniuqeKeyCount]]);
                UniuqeKeyCount++;
            }

            // Assemble the check existance statement
            sprintf(CheckExistanceStatement, "SELECT %s", cMyPKs.sPKs[0]);
            strcat(CheckExistanceStatement, " FROM [");
            strcat(CheckExistanceStatement, CCI[iClient].sCompanyDatabase);
            strcat(CheckExistanceStatement, "].[DBO].[");
            strcat(CheckExistanceStatement, sImportTable);
            strcat(CheckExistanceStatement, "] ");
            strcat(CheckExistanceStatement, WhereStatement);
        }

		if(bIsDelete == false && bCheckExistance)
		{
			if(iUniuqeKeysFound > 0)
			{
				if(!CCI[iClient].cCustSQL.Execute(CheckExistanceStatement, &rsTemp))
				{
					WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: Execute failed on CheckExistanceStatement.");

					sprintf(sStatusText, "Statement: %s", CheckExistanceStatement);
					WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

					//Need to do some advanced error reporting.
					if(CCI[iClient].cCustSQL.GetErrorMessage(sAltTemp, sizeof(sAltTemp), rsTemp.hSTMT))
					{
						sprintf(sStatusText, "Error Msg: %s", sAltTemp);
						WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
					}

					FreeSingleRowDataColumns(&SIM, iColumnCount);
					FreeSingleRowData(&SIM);
					FreeColumnNames(&SIM, iColumnCount);

			        cMyPKs.Free();
					fclose(hSource);
					return false;
				}

				iCountOfRowsThatAlreadyExist = rsTemp.RowCount;
				rsTemp.Close();
			}
		}

        char *sSrvSQL = NULL;
        bool bFreeSrvSQL = false;

        //----------------------------------------------------------------------------------------------
        if(bIsDelete)
		{
			if((sSrvSQL = (char *) calloc( sizeof(char), BaseMemoryRequirement + 1)) == NULL)
			{
				WriteLog(pSockSrvr->icClientID[iClient], "Failed to allocate memory for sSrvSQL.");

				FreeSingleRowDataColumns(&SIM, iColumnCount);
				FreeSingleRowData(&SIM);
				FreeColumnNames(&SIM, iColumnCount);

			    cMyPKs.Free();
				fclose(hSource);
				return false;
			}
			bFreeSrvSQL = true;

			sprintf(sSrvSQL, "DELETE FROM [%s].[DBO].[%s] %s",
				CCI[iClient].sCompanyDatabase, sImportTable, WhereStatement);
		}
		else if(iCountOfRowsThatAlreadyExist == 0) // Do insert
        {
			if((sSrvSQL = (char *) calloc( sizeof(char), BaseMemoryRequirement + 1)) == NULL)
			{
				WriteLog(pSockSrvr->icClientID[iClient], "Failed to allocate memory for sSrvSQL.");
				giErrorCount++;

				FreeSingleRowDataColumns(&SIM, iColumnCount);
				FreeSingleRowData(&SIM);
				FreeColumnNames(&SIM, iColumnCount);

			    cMyPKs.Free();
				fclose(hSource);
				return false;
			}
            bFreeSrvSQL = true;

			sprintf(sSrvSQL, "INSERT INTO [%s].[DBO].[%s] (", CCI[iClient].sCompanyDatabase, sImportTable);

            iColumnPos = 0;
            while(iColumnPos < iColumnCount)
            {
                strcat(sSrvSQL, "[");
                strcat(sSrvSQL, SIM.ColumnNames[iColumnPos]);
                strcat(sSrvSQL, "]");
                if(iColumnPos < iColumnCount - 1)
                {
                    strcat(sSrvSQL, ",");
                }
                iColumnPos++;
            }
            strcat(sSrvSQL, ") VALUES(");

            iColumnPos = 0;
            while(iColumnPos < iColumnCount)
            {
				strcat(sSrvSQL, SIM.SingleRowData[iColumnPos]);
                if(iColumnPos < iColumnCount - 1)
                {
                    strcat(sSrvSQL, ",");
                }
                iColumnPos++;
            }
            strcat(sSrvSQL, ") ");
        }
        //----------------------------------------------------------------------------------------------
        else { // Do update
            BaseMemoryRequirement = (BaseMemoryRequirement + strlen(WhereStatement));
            if((sSrvSQL = (char *) calloc( sizeof(char), BaseMemoryRequirement + 1)) == NULL)
			{
				WriteLog(pSockSrvr->icClientID[iClient], "Failed to allocate memory for sSrvSQL.");
				giErrorCount++;

				FreeSingleRowDataColumns(&SIM, iColumnCount);
				FreeSingleRowData(&SIM);
				FreeColumnNames(&SIM, iColumnCount);

			    cMyPKs.Free();
				fclose(hSource);
				return false;
			}
            bFreeSrvSQL = true;

            sprintf(sSrvSQL, "UPDATE [%s].[DBO].[%s] SET ", CCI[iClient].sCompanyDatabase, sImportTable);

            iColumnPos = 0;
            while(iColumnPos < iColumnCount)
            {
				strcat(sSrvSQL, "[");
                strcat(sSrvSQL, SIM.ColumnNames[iColumnPos]);
                strcat(sSrvSQL, "]=");
                strcat(sSrvSQL, SIM.SingleRowData[iColumnPos]);
                if(iColumnPos < iColumnCount - 1)
                {
                    strcat(sSrvSQL, ",");
                }
                iColumnPos++;
            }

            strcat(sSrvSQL, " ");
            strcat(sSrvSQL, WhereStatement);
        }

        //----------------------------------------------------------------------------------------------

        if(sSrvSQL != NULL)
        {
			if(!CCI[iClient].cCustSQL.Execute(sSrvSQL, &rsTemp))
            {
				WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: Execute failed on sSrvSQL.");

				sprintf(sStatusText, "Statement: %s", sSrvSQL);
				WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

				//Need to do some advanced error reporting.
				if(CCI[iClient].cCustSQL.GetErrorMessage(sAltTemp, sizeof(sAltTemp), rsTemp.hSTMT))
				{
					sprintf(sStatusText, "Error Msg: %s", sAltTemp);
					WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
				}

				FreeSingleRowDataColumns(&SIM, iColumnCount);
                FreeSingleRowData(&SIM);
                FreeColumnNames(&SIM, iColumnCount);

                free(sSrvSQL);

		        cMyPKs.Free();
                fclose(hSource);
                return false;
            }

            rsTemp.Close();
        }

        if(bFreeSrvSQL)
		{
            free(sSrvSQL);
		}

        sSrvSQL = NULL;

        FreeSingleRowDataColumns(&SIM, iColumnCount);
        //FreeSingleRowData(&SIM); // This memory needs to stay intact untill we are done with the import.

        iColumnPos++;

        RowPos++;

        if( pSockSrvr->bcConnected[iClient] == false )
        {
		    sprintf(sStatusText, "Disconnected durring data import, after %d successful rows.", RowPos);
			WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

            FreeSingleRowData(&SIM);
            FreeColumnNames(&SIM, iColumnCount);

	        cMyPKs.Free();
            fclose(hSource);
            return false;
        }
    }

    if(bIsDelete)
	{
		sprintf(sStatusText, "Successfully deleted %d client data rows.", RowPos);
	}
	else {
		sprintf(sStatusText, "Successfully imported %d client data rows.", RowPos);
	}
	WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

	//free some resources.
	free(iUniuqeKeyCols);
	FreeSingleRowData(&SIM);
    FreeColumnNames(&SIM, iColumnCount); 
    cMyPKs.Free();
    fclose(hSource);

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
